#pragma once
#include "cthread.h"
#include <string>
#include <vector>

using namespace std;

// FTP Command tokens
typedef enum {
    USER, PASS, CWD,  PORT, 
    QUIT, PASV, ABOR, DELE,
    RMD,  XRMD, MKD,  XMKD,
    PWD,  XPWD, LIST, NLST, 
    SYST, TYPE, MODE, RETR, 
    STOR, REST, RNFR, RNTO,
    STAT, NOOP, MDTM, xSIZE, 
	EXEC, REBO, CDUP,RAM,
    UNKNOWN_COMMAND, INVALID_COMMAND = -1
}CmdTypes;

struct command_list {
    char *command;
    CmdTypes CmdNum;
};

#define XFERSIZE 1024*128

typedef struct {
    char *command;
    CmdTypes CmdNum;
}Lookup_t;

class CFTPServerConn :
	public CThread
{
public:
	string DirNow;
	string Drive;
	vector <string> Drives;
    char XferBuffer[XFERSIZE];

    struct sockaddr_in xfer_addr;
    BOOL PassiveMode;
    int PassiveSocket;
    int CommandSocket;
    int XferPort;
	wstring xboxip;

	CFTPServerConn(void);
	~CFTPServerConn(void);
	unsigned long Process(void* parameter);
	void SendReply(char * reply);
	CmdTypes GetCommand(char *CmdArg) ;
	string MyGetDir(void);
	bool MySetDir(string dir);
	void Cmd_NLST(string filename, bool Long, bool UseCtrlConn);
	string TranslatePath(string inpath);
	int CreateTcpipSocket(int * Port);
	int ConnectTcpip(struct sockaddr_in *addr, int addrlen) ;
	void Send550Error();
	void Cmd_RETR(const char *filename);
	void Cmd_STOR(const char *filename);
	void Cmd_EXEC(const char *filename);
};
